<?php
include 'conexao.php';

$turmaId = $_GET['turma_id'] ?? 0;
$origem = $_GET['origem'] ?? 'atual';

$tabelaTurma = ($origem === 'anterior') ? 'turmas_anteriores' : 'turmas';

// Buscar dados da turma
$stmtTurma = $conn->prepare("SELECT * FROM $tabelaTurma WHERE id = ?");
$stmtTurma->bind_param("i", $turmaId);
$stmtTurma->execute();
$resTurma = $stmtTurma->get_result();
$turma = $resTurma->fetch_assoc();

// Buscar alunos (agora incluindo o ID)
$stmtAlunos = $conn->prepare("SELECT id, nome, idade, genero FROM alunos WHERE turma_id = ? AND origem = ?");
$stmtAlunos->bind_param("is", $turmaId, $origem);
$stmtAlunos->execute();
$resAlunos = $stmtAlunos->get_result();

$alunos = [];
while ($row = $resAlunos->fetch_assoc()) {
    $alunos[] = $row;
}

// Enviar como JSON
echo json_encode([
    "turma" => $turma,
    "alunos" => $alunos
]);
